<?php
/**
 * Class that operate on table 'resturantcategory'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-09-25 17:22
 */
class ResturantcategoryMySqlDAO implements ResturantcategoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return ResturantcategoryMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM resturantcategory WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM resturantcategory';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM resturantcategory ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param resturantcategory primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM resturantcategory WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ResturantcategoryMySql resturantcategory
 	 */
	public function insert($resturantcategory){
		$sql = 'INSERT INTO resturantcategory (category_id,product_id, date) VALUES (?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($resturantcategory->categoryId);
		$sqlQuery->set($resturantcategory->productId);
		$sqlQuery->set($resturantcategory->date);

		$id = $this->executeInsert($sqlQuery);	
		$resturantcategory->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param ResturantcategoryMySql resturantcategory
 	 */
	public function update($resturantcategory){
		$sql = 'UPDATE resturantcategory SET category_id = ?, product_id = ?,date = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($resturantcategory->categoryId);
		$sqlQuery->set($resturantcategory->productId);
		$sqlQuery->set($resturantcategory->date);

		$sqlQuery->setNumber($resturantcategory->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM resturantcategory';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByCategoryId($value){
		$sql = 'SELECT * FROM resturantcategory WHERE category_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM resturantcategory WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByCategoryId($value){
		$sql = 'DELETE FROM resturantcategory WHERE category_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDate($value){
		$sql = 'DELETE FROM resturantcategory WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return ResturantcategoryMySql 
	 */
	protected function readRow($row){
		$resturantcategory = new Resturantcategory();
		
		$resturantcategory->id = $row['id'];
		$resturantcategory->categoryId = $row['category_id'];
		$resturantcategory->productId = $row['product_id'];
		$resturantcategory->date = $row['date'];

		return $resturantcategory;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return ResturantcategoryMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>